package com.sprd.pacextractor;

import java.io.IOException;
import java.io.RandomAccessFile;

public class CheckCRC16 {
    public static final short SIZE_OF_PAC_HEADER = 2124; // bytes
    public static final long PAC_MAGIC = unsigned(0xFFFAFFFA);

    public static int unsigned(short n) {
        return n & 0xffff;
    }

    public static long unsigned(int n) {
        return n & 0xffffffffL;
    }

    public static short readShort(RandomAccessFile in) throws IOException {
        short result = 0;
        for (int i = 0; i < 2; i++) {
            result |= (in.readUnsignedByte() << (8 * i));
        }
        return result;
    }

    public static int readInt(RandomAccessFile in) throws IOException{
        int result = 0;
        for (int i = 0; i < 4; i++) {
            result |= (in.readUnsignedByte() << (8 * i));
        }
        return result;
    }

    public static void checkCRC16(RandomAccessFile in, boolean debug) throws IOException {
        CRC16 crc16 = new CRC16();
        in.seek(SIZE_OF_PAC_HEADER - 8);
        long dwMagic = unsigned(readInt(in));
        int read;
        if (dwMagic == PAC_MAGIC) {
            System.out.println("Checking CRC Part 1");
            in.seek(0);
            byte[] buffer = new byte[SIZE_OF_PAC_HEADER - 4];
            read = in.read(buffer);
            for (int i = 0; i < read; ++i)
                crc16.update(buffer[i]);
            int crc1InPac = unsigned(readShort(in));
            if (debug) System.out.println("Computed CRC1 = " + crc16.getValue() + ", CRC1 in PAC = " + crc1InPac);
            if (crc16.getValue() != crc1InPac) {
                System.err.println("CRC Check failed for CRC1\n");
                System.exit(1);
            }
        }

        System.out.println("Checking CRC Part 2");
        in.seek(SIZE_OF_PAC_HEADER - 2);
        crc16.reset();
        int crc2InPac = unsigned(readShort(in));
        byte[] buffer2 = new byte[64 * 1024]; // 64 KiB
        long len = in.length() - SIZE_OF_PAC_HEADER;
        while ((read = in.read(buffer2, 0, len < buffer2.length ? (int) len : buffer2.length)) > 0) {
            for (int i = 0; i < read; i++)
                crc16.update(buffer2[i]);
            len -= read;
        }
        if (debug) System.out.println("Computed CRC2 = " + crc16.getValue() + ", CRC2 in PAC = " + crc2InPac + "\n");
        if (crc16.getValue() != crc2InPac) {
            System.err.println("CRC Check failed for CRC2");
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: CheckCRC16 firmware.pac");
            System.exit(2);
        }

        RandomAccessFile in = null;
        try {
            in = new RandomAccessFile(args[0], "r");
            checkCRC16(in, true);
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        } finally {
            try {
                if (in != null) in.close();
            } catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }
}
