/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.utils;

import com.topjohnwu.utils.JarMap;
import com.topjohnwu.utils.SignAPK;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class ZipSigner {
    public static void usage() {
        System.err.println("ZipSigner usage:");
        System.err.println("  zipsigner.jar input.jar output.jar");
        System.err.println("    sign jar with AOSP test keys");
        System.err.println("  zipsigner.jar x509.pem pk8 input.jar output.jar");
        System.err.println("    sign jar with certificate / private key pair");
        System.err.println("  zipsigner.jar jks keyStorePass keyAlias keyPass input.jar output.jar");
        System.err.println("    sign jar with Java KeyStore");
        System.exit(2);
    }

    public static void main(String[] args) throws Exception {
        block63: {
            if (args.length != 2 && args.length != 4 && args.length != 6) {
                ZipSigner.usage();
            }
            try (JarMap in = new JarMap(args[args.length - 2], false);
                 FileOutputStream out = new FileOutputStream(args[args.length - 1]);){
                if (args.length == 2) {
                    SignAPK.sign(in, out);
                    break block63;
                }
                if (args.length == 4) {
                    try (FileInputStream cert = new FileInputStream(args[0]);
                         FileInputStream key = new FileInputStream(args[1]);){
                        SignAPK.sign(cert, key, in, (OutputStream)out);
                        break block63;
                    }
                }
                if (args.length != 6) break block63;
                try (FileInputStream jks = new FileInputStream(args[0]);){
                    SignAPK.sign(jks, args[1], args[2], args[3], in, out);
                }
            }
        }
    }
}

