/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.utils;

import com.topjohnwu.utils.CryptoUtils;
import com.topjohnwu.utils.JarMap;
import com.topjohnwu.utils.ZipAdjust;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.encoders.Base64;

public class SignAPK {
    private static final String CERT_SF_NAME = "META-INF/CERT.SF";
    private static final String CERT_SIG_NAME = "META-INF/CERT.%s";
    private static Provider sBouncyCastleProvider = new BouncyCastleProvider();
    private static final int USE_SHA1 = 1;
    private static final int USE_SHA256 = 2;
    private static Pattern stripPattern;

    public static void sign(JarMap input, OutputStream output) throws Exception {
        SignAPK.sign(SignAPK.class.getResourceAsStream("/keys/testkey.x509.pem"), SignAPK.class.getResourceAsStream("/keys/testkey.pk8"), input, output);
    }

    public static void sign(InputStream certIs, InputStream keyIs, JarMap input, OutputStream output) throws Exception {
        X509Certificate cert = CryptoUtils.readCertificate(certIs);
        PrivateKey key = CryptoUtils.readPrivateKey(keyIs);
        SignAPK.sign(cert, key, input, output);
    }

    public static void sign(InputStream jks, String keyStorePass, String alias, String keyPass, JarMap input, OutputStream output) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(jks, keyStorePass.toCharArray());
        X509Certificate cert = (X509Certificate)ks.getCertificate(alias);
        PrivateKey key = (PrivateKey)ks.getKey(alias, keyPass.toCharArray());
        SignAPK.sign(cert, key, input, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sign(X509Certificate cert, PrivateKey key, JarMap input, OutputStream output) throws Exception {
        File temp1 = File.createTempFile("signAPK", null);
        File temp2 = File.createTempFile("signAPK", null);
        try {
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(temp1));){
                SignAPK.sign(cert, key, input, out, false);
            }
            ZipAdjust.adjust(temp1, temp2);
            var7_7 = null;
            try (JarMap map = new JarMap(temp2, false);){
                SignAPK.sign(cert, key, map, output, true);
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
        }
        finally {
            temp1.delete();
            temp2.delete();
        }
    }

    private static void sign(X509Certificate cert, PrivateKey key, JarMap input, OutputStream output, boolean minSign) throws Exception {
        int hashes = 0;
        hashes |= SignAPK.getDigestAlgorithm(cert);
        long timestamp = cert.getNotBefore().getTime() + 3600000L;
        if (minSign) {
            SignAPK.signWholeFile(input.getFile(), cert, key, output);
        } else {
            JarOutputStream outputJar = new JarOutputStream(output);
            outputJar.setLevel(9);
            Manifest manifest = SignAPK.addDigestsToManifest(input, hashes);
            SignAPK.copyFiles(manifest, input, outputJar, timestamp, 4);
            SignAPK.signFile(manifest, input, cert, key, outputJar);
            outputJar.close();
        }
    }

    private static int getDigestAlgorithm(X509Certificate cert) {
        String sigAlg = cert.getSigAlgName().toUpperCase(Locale.US);
        if ("SHA1WITHRSA".equals(sigAlg) || "MD5WITHRSA".equals(sigAlg)) {
            return 1;
        }
        if (sigAlg.startsWith("SHA256WITH")) {
            return 2;
        }
        throw new IllegalArgumentException("unsupported signature algorithm \"" + sigAlg + "\" in cert [" + cert.getSubjectDN());
    }

    private static String getSignatureAlgorithm(X509Certificate cert) {
        String sigAlg = cert.getSigAlgName().toUpperCase(Locale.US);
        String keyType = cert.getPublicKey().getAlgorithm().toUpperCase(Locale.US);
        if ("RSA".equalsIgnoreCase(keyType)) {
            if (SignAPK.getDigestAlgorithm(cert) == 2) {
                return "SHA256withRSA";
            }
            return "SHA1withRSA";
        }
        if ("EC".equalsIgnoreCase(keyType)) {
            return "SHA256withECDSA";
        }
        throw new IllegalArgumentException("unsupported key type: " + keyType);
    }

    private static Manifest addDigestsToManifest(JarMap jar, int hashes) throws IOException, GeneralSecurityException {
        Manifest input = jar.getManifest();
        Manifest output = new Manifest();
        Attributes main = output.getMainAttributes();
        if (input != null) {
            main.putAll((Map<?, ?>)input.getMainAttributes());
        } else {
            main.putValue("Manifest-Version", "1.0");
            main.putValue("Created-By", "1.0 (Android SignApk)");
        }
        MessageDigest md_sha1 = null;
        MessageDigest md_sha256 = null;
        if ((hashes & 1) != 0) {
            md_sha1 = MessageDigest.getInstance("SHA1");
        }
        if ((hashes & 2) != 0) {
            md_sha256 = MessageDigest.getInstance("SHA256");
        }
        byte[] buffer = new byte[4096];
        TreeMap<String, JarEntry> byName = new TreeMap<String, JarEntry>();
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            byName.put(entry.getName(), entry);
        }
        for (JarEntry entry : byName.values()) {
            int num;
            String name = entry.getName();
            if (entry.isDirectory() || stripPattern != null && stripPattern.matcher(name).matches()) continue;
            InputStream data = jar.getInputStream(entry);
            while ((num = data.read(buffer)) > 0) {
                if (md_sha1 != null) {
                    md_sha1.update(buffer, 0, num);
                }
                if (md_sha256 == null) continue;
                md_sha256.update(buffer, 0, num);
            }
            Attributes attr = null;
            if (input != null) {
                attr = input.getAttributes(name);
            }
            Attributes attributes = attr = attr != null ? new Attributes(attr) : new Attributes();
            if (md_sha1 != null) {
                attr.putValue("SHA1-Digest", new String(Base64.encode(md_sha1.digest()), "ASCII"));
            }
            if (md_sha256 != null) {
                attr.putValue("SHA-256-Digest", new String(Base64.encode(md_sha256.digest()), "ASCII"));
            }
            output.getEntries().put(name, attr);
        }
        return output;
    }

    private static void writeSignatureFile(Manifest manifest, OutputStream out, int hash) throws IOException, GeneralSecurityException {
        Manifest sf = new Manifest();
        Attributes main = sf.getMainAttributes();
        main.putValue("Signature-Version", "1.0");
        main.putValue("Created-By", "1.0 (Android SignApk)");
        MessageDigest md = MessageDigest.getInstance(hash == 2 ? "SHA256" : "SHA1");
        PrintStream print = new PrintStream((OutputStream)new DigestOutputStream(new ByteArrayOutputStream(), md), true, "UTF-8");
        manifest.write(print);
        print.flush();
        main.putValue(hash == 2 ? "SHA-256-Digest-Manifest" : "SHA1-Digest-Manifest", new String(Base64.encode(md.digest()), "ASCII"));
        Map<String, Attributes> entries = manifest.getEntries();
        for (Map.Entry<String, Attributes> entry : entries.entrySet()) {
            print.print("Name: " + entry.getKey() + "\r\n");
            for (Map.Entry<Object, Object> att : entry.getValue().entrySet()) {
                print.print(att.getKey() + ": " + att.getValue() + "\r\n");
            }
            print.print("\r\n");
            print.flush();
            Attributes sfAttr = new Attributes();
            sfAttr.putValue(hash == 2 ? "SHA-256-Digest" : "SHA1-Digest-Manifest", new String(Base64.encode(md.digest()), "ASCII"));
            sf.getEntries().put(entry.getKey(), sfAttr);
        }
        CountOutputStream cout = new CountOutputStream(out);
        sf.write(cout);
        if (cout.size() % 1024 == 0) {
            cout.write(13);
            cout.write(10);
        }
    }

    private static void writeSignatureBlock(CMSTypedData data, X509Certificate publicKey, PrivateKey privateKey, OutputStream out) throws IOException, CertificateEncodingException, OperatorCreationException, CMSException {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>(1);
        certList.add(publicKey);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner signer = new JcaContentSignerBuilder(SignAPK.getSignatureAlgorithm(publicKey)).setProvider(sBouncyCastleProvider).build(privateKey);
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(sBouncyCastleProvider).build()).setDirectSignature(true).build(signer, publicKey));
        gen.addCertificates(certs);
        CMSSignedData sigData = gen.generate(data, false);
        ASN1InputStream asn1 = new ASN1InputStream(sigData.getEncoded());
        DEROutputStream dos = new DEROutputStream(out);
        dos.writeObject(asn1.readObject());
    }

    private static void copyFiles(Manifest manifest, JarMap in, JarOutputStream out, long timestamp, int alignment) throws IOException {
        int num;
        InputStream data;
        JarEntry outEntry;
        JarEntry inEntry;
        byte[] buffer = new byte[4096];
        Map<String, Attributes> entries = manifest.getEntries();
        ArrayList<String> names = new ArrayList<String>(entries.keySet());
        Collections.sort(names);
        boolean firstEntry = true;
        long offset = 0L;
        for (String name : names) {
            inEntry = in.getJarEntry(name);
            outEntry = null;
            if (inEntry.getMethod() != 0) continue;
            outEntry = new JarEntry(inEntry);
            outEntry.setTime(timestamp);
            offset += (long)(30 + outEntry.getName().length());
            if (firstEntry) {
                offset += 4L;
                firstEntry = false;
            }
            if (alignment > 0 && offset % (long)alignment != 0L) {
                int needed = alignment - (int)(offset % (long)alignment);
                outEntry.setExtra(new byte[needed]);
                offset += (long)needed;
            }
            out.putNextEntry(outEntry);
            data = in.getInputStream(inEntry);
            while ((num = data.read(buffer)) > 0) {
                out.write(buffer, 0, num);
                offset += (long)num;
            }
            out.flush();
        }
        for (String name : names) {
            inEntry = in.getJarEntry(name);
            outEntry = null;
            if (inEntry.getMethod() == 0) continue;
            outEntry = new JarEntry(name);
            outEntry.setTime(timestamp);
            out.putNextEntry(outEntry);
            data = in.getInputStream(inEntry);
            while ((num = data.read(buffer)) > 0) {
                out.write(buffer, 0, num);
            }
            out.flush();
        }
    }

    private static void signWholeFile(File input, X509Certificate publicKey, PrivateKey privateKey, OutputStream outputStream) throws Exception {
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        byte[] message = "signed by SignApk".getBytes("UTF-8");
        temp.write(message);
        temp.write(0);
        CMSProcessableFile cmsFile = new CMSProcessableFile(input);
        SignAPK.writeSignatureBlock(cmsFile, publicKey, privateKey, temp);
        byte[] zipData = cmsFile.getTail();
        if (zipData[zipData.length - 22] != 80 || zipData[zipData.length - 21] != 75 || zipData[zipData.length - 20] != 5 || zipData[zipData.length - 19] != 6) {
            throw new IllegalArgumentException("zip data already has an archive comment");
        }
        int total_size = temp.size() + 6;
        if (total_size > 65535) {
            throw new IllegalArgumentException("signature is too big for ZIP file comment");
        }
        int signature_start = total_size - message.length - 1;
        temp.write(signature_start & 0xFF);
        temp.write(signature_start >> 8 & 0xFF);
        temp.write(255);
        temp.write(255);
        temp.write(total_size & 0xFF);
        temp.write(total_size >> 8 & 0xFF);
        temp.flush();
        byte[] b = temp.toByteArray();
        for (int i = 0; i < b.length - 3; ++i) {
            if (b[i] != 80 || b[i + 1] != 75 || b[i + 2] != 5 || b[i + 3] != 6) continue;
            throw new IllegalArgumentException("found spurious EOCD header at " + i);
        }
        cmsFile.write(outputStream);
        outputStream.write(total_size & 0xFF);
        outputStream.write(total_size >> 8 & 0xFF);
        temp.writeTo(outputStream);
        outputStream.close();
    }

    private static void signFile(Manifest manifest, JarMap inputJar, X509Certificate publicKey, PrivateKey privateKey, JarOutputStream outputJar) throws Exception {
        long timestamp = publicKey.getNotBefore().getTime() + 3600000L;
        JarEntry je = new JarEntry("META-INF/MANIFEST.MF");
        je.setTime(timestamp);
        outputJar.putNextEntry(je);
        manifest.write(outputJar);
        je = new JarEntry(CERT_SF_NAME);
        je.setTime(timestamp);
        outputJar.putNextEntry(je);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SignAPK.writeSignatureFile(manifest, baos, SignAPK.getDigestAlgorithm(publicKey));
        byte[] signedData = baos.toByteArray();
        outputJar.write(signedData);
        String keyType = publicKey.getPublicKey().getAlgorithm();
        je = new JarEntry(String.format(CERT_SIG_NAME, keyType));
        je.setTime(timestamp);
        outputJar.putNextEntry(je);
        SignAPK.writeSignatureBlock(new CMSProcessableByteArray(signedData), publicKey, privateKey, outputJar);
    }

    static {
        Security.insertProviderAt(sBouncyCastleProvider, 1);
        stripPattern = Pattern.compile("^(META-INF/((.*)[.](SF|RSA|DSA|EC)|com/android/otacert))|(" + Pattern.quote("META-INF/MANIFEST.MF") + ")$");
    }

    private static class CMSProcessableFile
    implements CMSTypedData {
        private ASN1ObjectIdentifier type;
        private RandomAccessFile file;

        CMSProcessableFile(File file) throws FileNotFoundException {
            this.file = new RandomAccessFile(file, "r");
            this.type = new ASN1ObjectIdentifier(CMSObjectIdentifiers.data.getId());
        }

        @Override
        public ASN1ObjectIdentifier getContentType() {
            return this.type;
        }

        @Override
        public void write(OutputStream out) throws IOException, CMSException {
            int read;
            this.file.seek(0L);
            byte[] buffer = new byte[4096];
            int len = (int)this.file.length() - 2;
            while ((read = this.file.read(buffer, 0, len < buffer.length ? len : buffer.length)) > 0) {
                out.write(buffer, 0, read);
                len -= read;
            }
        }

        @Override
        public Object getContent() {
            return this.file;
        }

        byte[] getTail() throws IOException {
            byte[] tail = new byte[22];
            this.file.seek(this.file.length() - 22L);
            this.file.readFully(tail);
            return tail;
        }
    }

    private static class CountOutputStream
    extends FilterOutputStream {
        private int mCount = 0;

        public CountOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            super.write(b);
            ++this.mCount;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
            this.mCount += len;
        }

        public int size() {
            return this.mCount;
        }
    }
}

