/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import java.io.PrintStream;
import java.io.PrintWriter;

public class ExceptionWithContext
extends RuntimeException {
    private StringBuffer context;

    public static ExceptionWithContext withContext(Throwable ex, String str, Object ... formatArgs) {
        ExceptionWithContext ewc = ex instanceof ExceptionWithContext ? (ExceptionWithContext)ex : new ExceptionWithContext(ex);
        ewc.addContext(String.format(str, formatArgs));
        return ewc;
    }

    public ExceptionWithContext(String message, Object ... formatArgs) {
        this(null, message, formatArgs);
    }

    public ExceptionWithContext(Throwable cause) {
        this(cause, null, new Object[0]);
    }

    public ExceptionWithContext(Throwable cause, String message, Object ... formatArgs) {
        super(message != null ? ExceptionWithContext.formatMessage(message, formatArgs) : (cause != null ? cause.getMessage() : null), cause);
        if (cause instanceof ExceptionWithContext) {
            String ctx = ((ExceptionWithContext)cause).context.toString();
            this.context = new StringBuffer(ctx.length() + 200);
            this.context.append(ctx);
        } else {
            this.context = new StringBuffer(200);
        }
    }

    private static String formatMessage(String message, Object ... formatArgs) {
        if (message == null) {
            return null;
        }
        return String.format(message, formatArgs);
    }

    @Override
    public void printStackTrace(PrintStream out) {
        super.printStackTrace(out);
        out.println(this.context);
    }

    @Override
    public void printStackTrace(PrintWriter out) {
        super.printStackTrace(out);
        out.println(this.context);
    }

    public void addContext(String str) {
        if (str == null) {
            throw new NullPointerException("str == null");
        }
        this.context.append(str);
        if (!str.endsWith("\n")) {
            this.context.append('\n');
        }
    }
}

