/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import java.io.IOException;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.Adaptors.LabelMethodItem;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.baksmali.BaksmaliOptions;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.iface.instruction.OffsetInstruction;
import org.jf.util.IndentingWriter;

public class OffsetInstructionFormatMethodItem
extends InstructionMethodItem<OffsetInstruction> {
    protected LabelMethodItem label;

    public OffsetInstructionFormatMethodItem(BaksmaliOptions options, MethodDefinition methodDef, int codeAddress, OffsetInstruction instruction) {
        super(methodDef, codeAddress, instruction);
        this.label = new LabelMethodItem(options, codeAddress + instruction.getCodeOffset(), this.getLabelPrefix());
        this.label = methodDef.getLabelCache().internLabel(this.label);
    }

    @Override
    protected void writeTargetLabel(IndentingWriter writer) throws IOException {
        this.label.writeTo(writer);
    }

    private String getLabelPrefix() {
        Opcode opcode = ((OffsetInstruction)this.instruction).getOpcode();
        switch (opcode.format) {
            case Format10t: 
            case Format20t: 
            case Format30t: {
                return "goto_";
            }
            case Format21t: 
            case Format22t: {
                return "cond_";
            }
            case Format31t: {
                if (opcode == Opcode.FILL_ARRAY_DATA) {
                    return "array_";
                }
                if (opcode == Opcode.PACKED_SWITCH) {
                    return "pswitch_data_";
                }
                return "sswitch_data_";
            }
        }
        assert (false);
        return null;
    }
}

