/*
 * Decompiled with CFR 0.152.
 */
package brut.util;

import brut.common.BrutException;
import brut.util.Jar;
import brut.util.OS;
import brut.util.OSDetection;
import java.io.File;
import java.util.ArrayList;

public class AaptManager {
    public static File getAppt2() throws BrutException {
        return AaptManager.getAppt(2);
    }

    public static File getAppt1() throws BrutException {
        return AaptManager.getAppt(1);
    }

    private static File getAppt(Integer version) throws BrutException {
        File aaptBinary;
        block7: {
            String aaptVersion = AaptManager.getAaptBinaryName(version);
            if (!OSDetection.is64Bit() && OSDetection.isMacOSX()) {
                throw new BrutException("32 bit OS detected. No 32 bit binaries available.");
            }
            aaptVersion = aaptVersion + (OSDetection.is64Bit() ? "_64" : "");
            try {
                if (OSDetection.isMacOSX()) {
                    aaptBinary = Jar.getResourceAsFile("/prebuilt/macosx/" + aaptVersion, AaptManager.class);
                    break block7;
                }
                if (OSDetection.isUnix()) {
                    aaptBinary = Jar.getResourceAsFile("/prebuilt/linux/" + aaptVersion, AaptManager.class);
                    break block7;
                }
                if (OSDetection.isWindows()) {
                    aaptBinary = Jar.getResourceAsFile("/prebuilt/windows/" + aaptVersion + ".exe", AaptManager.class);
                    break block7;
                }
                throw new BrutException("Could not identify platform: " + OSDetection.returnOS());
            }
            catch (BrutException ex) {
                throw new BrutException(ex);
            }
        }
        if (aaptBinary.setExecutable(true)) {
            return aaptBinary;
        }
        throw new BrutException("Can't set aapt binary as executable");
    }

    public static String getAaptExecutionCommand(String aaptPath, File aapt) throws BrutException {
        if (!aaptPath.isEmpty()) {
            File aaptFile = new File(aaptPath);
            if (aaptFile.canRead() && aaptFile.exists()) {
                aaptFile.setExecutable(true);
                return aaptFile.getPath();
            }
            throw new BrutException("binary could not be read: " + aaptFile.getAbsolutePath());
        }
        return aapt.getAbsolutePath();
    }

    public static int getAaptVersion(String aaptLocation) throws BrutException {
        return AaptManager.getApptVersion(new File(aaptLocation));
    }

    public static String getAaptBinaryName(Integer version) {
        return "aapt" + (version == 2 ? "2" : "");
    }

    public static int getAppVersionFromString(String version) throws BrutException {
        if (version.startsWith("Android Asset Packaging Tool (aapt) 2:")) {
            return 2;
        }
        if (version.startsWith("Android Asset Packaging Tool (aapt) 2.")) {
            return 2;
        }
        if (version.startsWith("Android Asset Packaging Tool, v0.")) {
            return 1;
        }
        throw new BrutException("aapt version could not be identified: " + version);
    }

    public static int getApptVersion(File aapt) throws BrutException {
        if (!aapt.isFile()) {
            throw new BrutException("Could not identify aapt binary as executable.");
        }
        aapt.setExecutable(true);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(aapt.getAbsolutePath());
        cmd.add("version");
        String version = OS.execAndReturn(cmd.toArray(new String[0]));
        if (version == null) {
            throw new BrutException("Could not execute aapt binary at location: " + aapt.getAbsolutePath());
        }
        return AaptManager.getAppVersionFromString(version);
    }
}

