/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.AndrolibException;
import brut.androlib.err.UndefinedResObjectException;
import brut.androlib.res.data.ResConfigFlags;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.ResType;
import brut.androlib.res.data.ResTypeSpec;
import brut.androlib.res.data.ResValuesFile;
import brut.androlib.res.data.value.ResFileValue;
import brut.androlib.res.data.value.ResValueFactory;
import brut.androlib.res.xml.ResValuesXmlSerializable;
import brut.util.Duo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class ResPackage {
    private final ResTable mResTable;
    private final int mId;
    private final String mName;
    private final Map<ResID, ResResSpec> mResSpecs = new LinkedHashMap<ResID, ResResSpec>();
    private final Map<ResConfigFlags, ResType> mConfigs = new LinkedHashMap<ResConfigFlags, ResType>();
    private final Map<String, ResTypeSpec> mTypes = new LinkedHashMap<String, ResTypeSpec>();
    private final Set<ResID> mSynthesizedRes = new HashSet<ResID>();
    private ResValueFactory mValueFactory;
    private static final Logger LOGGER = Logger.getLogger(ResPackage.class.getName());

    public ResPackage(ResTable resTable, int id, String name) {
        this.mResTable = resTable;
        this.mId = id;
        this.mName = name;
    }

    public List<ResResSpec> listResSpecs() {
        return new ArrayList<ResResSpec>(this.mResSpecs.values());
    }

    public boolean hasResSpec(ResID resID) {
        return this.mResSpecs.containsKey(resID);
    }

    public ResResSpec getResSpec(ResID resID) throws UndefinedResObjectException {
        ResResSpec spec = this.mResSpecs.get(resID);
        if (spec == null) {
            throw new UndefinedResObjectException("resource spec: " + resID.toString());
        }
        return spec;
    }

    public int getResSpecCount() {
        return this.mResSpecs.size();
    }

    public ResType getOrCreateConfig(ResConfigFlags flags) throws AndrolibException {
        ResType config = this.mConfigs.get(flags);
        if (config == null) {
            config = new ResType(flags);
            this.mConfigs.put(flags, config);
        }
        return config;
    }

    public Set<ResResource> listFiles() {
        HashSet<ResResource> ret = new HashSet<ResResource>();
        for (ResResSpec spec : this.mResSpecs.values()) {
            for (ResResource res : spec.listResources()) {
                if (!(res.getValue() instanceof ResFileValue)) continue;
                ret.add(res);
            }
        }
        return ret;
    }

    public Collection<ResValuesFile> listValuesFiles() {
        HashMap<Duo<ResTypeSpec, ResType>, ResValuesFile> ret = new HashMap<Duo<ResTypeSpec, ResType>, ResValuesFile>();
        for (ResResSpec spec : this.mResSpecs.values()) {
            for (ResResource res : spec.listResources()) {
                ResType config;
                if (!(res.getValue() instanceof ResValuesXmlSerializable)) continue;
                ResTypeSpec type = res.getResSpec().getType();
                Duo<ResTypeSpec, ResType> key = new Duo<ResTypeSpec, ResType>(type, config = res.getConfig());
                ResValuesFile values = (ResValuesFile)ret.get(key);
                if (values == null) {
                    values = new ResValuesFile(this, type, config);
                    ret.put(key, values);
                }
                values.addResource(res);
            }
        }
        return ret.values();
    }

    public ResTable getResTable() {
        return this.mResTable;
    }

    public int getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    boolean isSynthesized(ResID resId) {
        return this.mSynthesizedRes.contains(resId);
    }

    public void removeResSpec(ResResSpec spec) throws AndrolibException {
        this.mResSpecs.remove(spec.getId());
    }

    public void addResSpec(ResResSpec spec) throws AndrolibException {
        if (this.mResSpecs.put(spec.getId(), spec) != null) {
            throw new AndrolibException("Multiple resource specs: " + spec);
        }
    }

    public void addType(ResTypeSpec type) throws AndrolibException {
        if (this.mTypes.containsKey(type.getName())) {
            LOGGER.warning("Multiple types detected! " + type + " ignored!");
        } else {
            this.mTypes.put(type.getName(), type);
        }
    }

    public void addResource(ResResource res) {
    }

    public void addSynthesizedRes(int resId) {
        this.mSynthesizedRes.add(new ResID(resId));
    }

    public String toString() {
        return this.mName;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResPackage other = (ResPackage)obj;
        if (!(this.mResTable == other.mResTable || this.mResTable != null && this.mResTable.equals(other.mResTable))) {
            return false;
        }
        return this.mId == other.mId;
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + (this.mResTable != null ? this.mResTable.hashCode() : 0);
        hash = 31 * hash + this.mId;
        return hash;
    }

    public ResValueFactory getValueFactory() {
        if (this.mValueFactory == null) {
            this.mValueFactory = new ResValueFactory(this);
        }
        return this.mValueFactory;
    }
}

