# Terminal Toolbar Commands JSON 配置文件使用说明

## 概述

`terminal_toolbar_commands.json` 是 应用中终端工具栏快捷按钮的配置文件，用于定义在终端界面工具栏中显示的快捷命令按钮。该文件位于 `data/flutter_assets/assets/terminal_toolbar_commands.json`，提供了一种快速访问常用命令的方式。

## 文件结构

配置文件是一个 JSON 数组，包含多个工具栏命令条目。

### 基本结构

```json
[
  {
    "label": "按钮标签",
    "command": "要执行的命令",
    "tooltip": "鼠标悬停提示",
    "icon": "图标名称"
  }
]
```

## 字段说明

| 字段名 | 类型 | 必需 | 说明 |
|--------|------|------|------|
| `label` | String | ✅ | 按钮显示的文本标签 |
| `command` | String | ✅ | 点击按钮时执行的命令 |
| `tooltip` | String | ✅ | 鼠标悬停时显示的提示信息 |
| `icon` | String | ✅ | 按钮图标，使用 FluentUI 图标 |

### 字段详解

#### label
- 显示在工具栏按钮上的文本
- 建议使用简短、易识别的标签
- 支持中文和英文

#### command
- 点击按钮时在终端中执行的命令
- 命令末尾可以添加换行符控制执行方式：
  - `\r\n`: Windows 风格换行，自动执行命令
  - `\n`: Unix 风格换行，自动执行命令
  - 无换行符: 仅输入命令，不自动执行

#### tooltip
- 鼠标悬停在按钮上时显示的详细说明
- 用于提供命令的功能描述
- 支持多语言描述

#### icon
- 使用 FluentUI 图标库的图标
- 格式：`fluent.FluentIcons.图标名`
- 图标应与命令功能相关联

## 命令执行方式

### 自动执行命令
使用换行符结尾的命令会自动执行：

```json
{
  "label": "Cls",
  "command": "cls \r\n",
  "tooltip": "Clear terminal screen",
  "icon": "fluent.FluentIcons.clear_formatting"
}
```

### 仅输入命令
不带换行符的命令只会输入到终端，需要用户手动按回车：

```json
{
  "label": "ping",
  "command": "ping z.cn",
  "tooltip": "Ping test",
  "icon": "fluent.FluentIcons.globe"
}
```

## 配置示例

### 当前配置文件示例

```json
[
  {
    "label": "ls",
    "command": "ls -la \n",
    "tooltip": "List all files (detailed)",
    "icon": "fluent.FluentIcons.bulleted_list"
  },
  {
    "label": "ping",
    "command": "ping z.cn",
    "tooltip": "Ping test",
    "icon": "fluent.FluentIcons.globe"
  },
  {
    "label": "Cls",
    "command": "cls \r\n",
    "tooltip": "Clear terminal screen",
    "icon": "fluent.FluentIcons.clear_formatting"
  },
  {
    "label": "Wsl",
    "command": "wsl \r\n",
    "tooltip": "start wsl",
    "icon": "fluent.FluentIcons.command_prompt"
  },
  {
    "label": "Clear",
    "command": "clear \n",
    "tooltip": "Clear terminal screen",
    "icon": "fluent.FluentIcons.delete"
  },
  {
    "label": "pwd",
    "command": "pwd \n",
    "tooltip": "Print working directory",
    "icon": "fluent.FluentIcons.folder_open"
  },
  {
    "label": "ps",
    "command": "ps aux \n",
    "tooltip": "Show running processes",
    "icon": "fluent.FluentIcons.processing"
  },
  {
    "label": "top",
    "command": "top \n",
    "tooltip": "Show system processes",
    "icon": "fluent.FluentIcons.chart"
  }
]
```

## 常用图标参考

### 系统命令图标

```json
"fluent.FluentIcons.bulleted_list"      // 列表 (ls, dir)
"fluent.FluentIcons.folder_open"        // 文件夹 (pwd, cd)
"fluent.FluentIcons.clear_formatting"   // 清除 (cls, clear)
"fluent.FluentIcons.delete"             // 删除 (rm, del)
"fluent.FluentIcons.command_prompt"     // 命令提示符 (cmd, bash)
"fluent.FluentIcons.processing"         // 进程 (ps, tasklist)
"fluent.FluentIcons.chart"              // 图表 (top, htop)
```

### 网络命令图标

```json
"fluent.FluentIcons.globe"              // 网络 (ping, curl)
"fluent.FluentIcons.wifi"               // WiFi (netstat, ifconfig)
"fluent.FluentIcons.cloud"              // 云服务 (ssh, scp)
"fluent.FluentIcons.download"           // 下载 (wget, curl)
```

### 开发工具图标

```json
"fluent.FluentIcons.code"               // 代码 (git, npm)
"fluent.FluentIcons.source_control"     // 版本控制 (git)
"fluent.FluentIcons.build_definition"   // 构建 (make, build)
"fluent.FluentIcons.test_case"          // 测试 (test, jest)
```

### 文件操作图标

```json
"fluent.FluentIcons.copy"               // 复制 (cp, copy)
"fluent.FluentIcons.move"               // 移动 (mv, move)
"fluent.FluentIcons.search"             // 搜索 (find, grep)
"fluent.FluentIcons.edit"               // 编辑 (nano, vim)
```

## 平台兼容性

### Windows 命令示例

```json
{
  "label": "Dir",
  "command": "dir \r\n",
  "tooltip": "List directory contents",
  "icon": "fluent.FluentIcons.bulleted_list"
},
{
  "label": "Cls",
  "command": "cls \r\n",
  "tooltip": "Clear screen",
  "icon": "fluent.FluentIcons.clear_formatting"
},
{
  "label": "Tasklist",
  "command": "tasklist \r\n",
  "tooltip": "Show running tasks",
  "icon": "fluent.FluentIcons.processing"
}
```

### Linux/macOS 命令示例

```json
{
  "label": "ls",
  "command": "ls -la \n",
  "tooltip": "List files with details",
  "icon": "fluent.FluentIcons.bulleted_list"
},
{
  "label": "clear",
  "command": "clear \n",
  "tooltip": "Clear terminal",
  "icon": "fluent.FluentIcons.clear_formatting"
},
{
  "label": "ps",
  "command": "ps aux \n",
  "tooltip": "Show processes",
  "icon": "fluent.FluentIcons.processing"
}
```

## 最佳实践

### 1. 按钮设计

- **简洁标签**: 使用 2-5 个字符的简短标签
- **清晰图标**: 选择与命令功能相关的图标
- **有用提示**: 提供清晰的 tooltip 说明

### 2. 命令选择

- **常用命令**: 优先添加经常使用的命令
- **快速操作**: 选择执行频率高的简单命令
- **平台适配**: 考虑不同操作系统的命令差异

### 3. 排序组织

- **使用频率**: 将最常用的命令放在前面
- **功能分组**: 相似功能的命令放在一起
- **逻辑顺序**: 按照工作流程排列命令

### 4. 命令格式

- **自动执行**: 对于安全的查看命令使用 `\r\n` 或 `\n`
- **手动确认**: 对于可能有风险的命令不加换行符
- **参数预设**: 为命令预设常用参数

## 自定义配置示例

### 开发者工具栏

```json
[
  {
    "label": "git",
    "command": "git status \n",
    "tooltip": "Check git status",
    "icon": "fluent.FluentIcons.source_control"
  },
  {
    "label": "npm",
    "command": "npm run ",
    "tooltip": "Run npm script",
    "icon": "fluent.FluentIcons.package"
  },
  {
    "label": "test",
    "command": "npm test \n",
    "tooltip": "Run tests",
    "icon": "fluent.FluentIcons.test_case"
  },
  {
    "label": "build",
    "command": "npm run build \n",
    "tooltip": "Build project",
    "icon": "fluent.FluentIcons.build_definition"
  }
]
```

### 系统管理工具栏

```json
[
  {
    "label": "htop",
    "command": "htop \n",
    "tooltip": "System monitor",
    "icon": "fluent.FluentIcons.chart"
  },
  {
    "label": "df",
    "command": "df -h \n",
    "tooltip": "Disk usage",
    "icon": "fluent.FluentIcons.hard_drive"
  },
  {
    "label": "free",
    "command": "free -h \n",
    "tooltip": "Memory usage",
    "icon": "fluent.FluentIcons.memory"
  },
  {
    "label": "uptime",
    "command": "uptime \n",
    "tooltip": "System uptime",
    "icon": "fluent.FluentIcons.clock"
  }
]
```

## 注意事项

### 1. JSON 格式
- 确保 JSON 语法正确
- 注意逗号和引号的使用
- 最后一个对象后不要加逗号

### 2. 命令安全
- 避免添加危险的删除命令
- 对于修改系统的命令要谨慎
- 考虑命令的副作用

### 3. 平台兼容
- Windows 和 Unix 系统命令不同
- 考虑使用条件配置或多套配置
- 测试命令在目标平台的可用性

### 4. 用户体验
- 保持工具栏按钮数量适中（建议 6-12 个）
- 确保图标和标签的一致性
- 提供有意义的 tooltip

## 故障排除

### 常见问题

1. **按钮不显示**: 检查 JSON 格式是否正确
2. **命令不执行**: 确认命令在当前系统中可用
3. **图标不显示**: 验证图标名称是否正确
4. **换行符问题**: 检查 `\r\n` 和 `\n` 的使用

### 调试方法

1. 使用 JSON 验证工具检查格式
2. 在终端中手动测试命令
3. 检查应用日志输出
4. 逐个添加按钮进行测试

## 扩展功能

### 未来可能的增强

- 动态按钮（基于当前目录或项目类型）
- 按钮分组和折叠
- 自定义快捷键绑定
- 命令历史和使用统计
- 条件显示（基于操作系统或环境）

---

通过合理配置 `terminal_toolbar_commands.json`，可以为用户提供便捷的终端操作快捷方式，提高工作效率。 