# 终端工具箱配置文件使用说明1

## 概述

`quick_commands.json` 是 应用中快捷命令面板的配置文件，用于定义可快速执行的命令和操作。该文件位于 `data/flutter_assets/assets/quick_commands.json`，支持分类管理和多种命令类型。

## 文件结构

配置文件是一个 JSON 数组，包含命令条目（Command Entry）和命令分类（Command Category）。

### 基本结构

```json
[
  {
    "name": "命令或分类名称",
    "icon": "图标名称",
    "type": "命令类型",
    "value": "命令值或执行内容",
    "expanded": true/false,
    "commands": [...]
  }
]
```

## 字段说明

### 通用字段

| 字段名 | 类型 | 必需 | 说明 |
|--------|------|------|------|
| `name` | String | ✅ | 命令或分类的显示名称 |
| `icon` | String | ❌ | 图标名称，使用 FluentUI 图标 |
| `type` | String | ✅ | 命令类型，决定执行方式 |

### 分类特有字段

| 字段名 | 类型 | 必需 | 说明 |
|--------|------|------|------|
| `commands` | Array | ✅ | 子命令列表 |
| `expanded` | Boolean | ❌ | 是否默认展开，默认为 false |

### 命令特有字段

| 字段名 | 类型 | 必需 | 说明 |
|--------|------|------|------|
| `value` | String | ✅ | 要执行的命令内容 |
| `children` | Array | ❌ | 嵌套子命令（暂未使用） |

## 命令类型详解

### 1. category - 命令分类

用于组织和分类命令，可以包含多个子命令。

```json
{
  "name": "ADB 调试命令",
  "icon": "fluent.FluentIcons.robot",
  "type": "category",
  "expanded": true,
  "commands": [
    // 子命令列表
  ]
}
```

**特点：**
- 可折叠/展开
- 支持嵌套命令
- `expanded` 控制默认展开状态

### 2. terminal - 终端命令

在当前终端会话中执行命令。

```json
{
  "name": "查看连接的设备",
  "icon": "fluent.FluentIcons.usb",
  "type": "terminal",
  "value": "adb devices \r\n"
}
```

**特点：**
- 在当前终端执行
- 命令末尾的 `\r\n` 表示自动回车执行

### 3. terminalShell - Shell 命令

在新的 Shell 进程中执行命令。

```json
{
  "name": "列出文件(详细)",
  "icon": "fluent.FluentIcons.bulleted_list",
  "type": "terminalShell",
  "value": "ls -la \n"
}
```

**特点：**
- 在新的 Shell 进程中执行
- 适合需要独立环境的命令

### 4. terminalWindow - 新终端窗口

在新的终端窗口中执行命令。

```json
{
  "name": "新窗口执行命令",
  "icon": "fluent.FluentIcons.open_in_new_window",
  "type": "terminalWindow",
  "value": "htop \r\n"
}
```

**特点：**
- 打开新的终端窗口
- 适合长时间运行的程序

### 5. popup - 弹窗显示

以弹窗形式显示命令执行结果。

```json
{
  "name": "弹窗显示日期",
  "icon": "fluent.FluentIcons.calendar",
  "type": "popup",
  "value": "date"
}
```

**特点：**
- 结果以弹窗形式显示
- 适合查看简短信息

### 6. open_program - 打开程序

启动外部程序或应用。

```json
{
  "name": "打开计算器",
  "icon": "fluent.FluentIcons.calculator",
  "type": "open_program",
  "value": "calc.exe"
}
```

**特点：**
- 启动系统程序
- 支持带参数的程序启动

### 7. plugin - 插件执行

执行自定义插件功能。

```json
{
  "name": "执行自定义插件",
  "icon": "fluent.FluentIcons.code",
  "type": "plugin",
  "value": "my_plugin_id"
}
```

**特点：**
- 调用应用内插件
- 需要对应的插件实现

## 图标使用

图标使用 FluentUI 图标库，格式为 `fluent.FluentIcons.图标名`。

### 常用图标示例

```json
"fluent.FluentIcons.robot"           // 机器人
"fluent.FluentIcons.settings"        // 设置
"fluent.FluentIcons.wifi"            // WiFi
"fluent.FluentIcons.code"            // 代码
"fluent.FluentIcons.lightning_bolt"  // 闪电
"fluent.FluentIcons.command_prompt"  // 命令提示符
"fluent.FluentIcons.folder"          // 文件夹
"fluent.FluentIcons.usb"             // USB
"fluent.FluentIcons.help"            // 帮助
"fluent.FluentIcons.refresh"         // 刷新
"fluent.FluentIcons.globe"           // 地球
"fluent.FluentIcons.calendar"        // 日历
"fluent.FluentIcons.calculator"      // 计算器
"fluent.FluentIcons.edit"            // 编辑
"fluent.FluentIcons.clock"           // 时钟
```

## 配置示例

### 完整的分类配置

```json
{
  "name": "开发工具",
  "icon": "fluent.FluentIcons.code",
  "type": "category",
  "expanded": false,
  "commands": [
    {
      "name": "Git 状态",
      "icon": "fluent.FluentIcons.source_control",
      "type": "terminal",
      "value": "git status \r\n"
    },
    {
      "name": "Flutter 清理",
      "icon": "fluent.FluentIcons.clear_formatting",
      "type": "terminal",
      "value": "flutter clean \r\n"
    }
  ]
}
```

### 独立命令配置

```json
{
  "name": "显示当前时间",
  "icon": "fluent.FluentIcons.clock",
  "type": "terminal",
  "value": "date \r\n"
}
```

## 最佳实践

### 1. 命令组织

- 使用分类将相关命令分组
- 为常用分类设置 `"expanded": true`
- 保持分类层级简单，避免过度嵌套

### 2. 命令命名

- 使用清晰、描述性的命令名称
- 避免过长的名称，保持界面整洁
- 使用中文或英文保持一致性

### 3. 图标选择

- 为每个命令和分类选择合适的图标
- 保持图标风格一致
- 使用语义化的图标提高可识别性

### 4. 命令类型选择

- `terminal`: 适合快速执行的命令
- `terminalShell`: 适合需要独立环境的命令
- `popup`: 适合查看简短信息
- `open_program`: 适合启动外部程序

### 5. 命令值格式

- 终端命令末尾添加 `\r\n` 自动执行
- Shell 命令末尾添加 `\n`
- 程序路径使用完整路径或系统 PATH 中的程序名

## 注意事项

1. **JSON 格式**: 确保 JSON 格式正确，注意逗号和引号
2. **字符转义**: 在命令中使用特殊字符时需要正确转义
3. **平台兼容**: 考虑不同操作系统的命令差异
4. **权限问题**: 某些命令可能需要管理员权限
5. **路径问题**: 使用绝对路径或确保程序在 PATH 中

## 故障排除

### 常见问题

1. **命令不执行**: 检查命令类型和值是否正确
2. **图标不显示**: 确认图标名称是否正确
3. **分类不展开**: 检查 JSON 格式和 `expanded` 字段
4. **程序无法启动**: 确认程序路径和权限

### 调试方法

1. 检查应用日志输出
2. 验证 JSON 格式的正确性
3. 测试命令在终端中是否能正常执行
4. 确认文件路径和权限设置

## 扩展功能

### 未来可能支持的功能

- 命令参数化（用户输入参数）
- 条件执行（基于系统状态）
- 命令链（顺序执行多个命令）
- 自定义快捷键绑定
- 命令历史记录

---

通过合理配置 `quick_commands.json`，可以大大提高终端操作的效率。 